# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.

bl_info = {
    "name" : "BLCN",
    "author" : "斑斓社区 - Kirk.",
    "description" : "在菜单栏添加切换blender界面语言,切换主题按钮",
    "blender" : (2, 80, 0),
    "version" : (0, 0, 2),
    "location" : "菜单栏",
    "warning" : "",
    "category" : "Generic",
    "doc_url": "https://www.blendercn.org/" "",
}

import bpy

class BasicMenu(bpy.types.Menu):
    bl_idname = "OBJECT_MT_select_test"
    bl_label = "Select"
    
    def draw(self, context):
        layout = self.layout
        row = layout.row(align=True)
        row.scale_x = 1.2
        row.operator(BLCN_zh_CN_en_US.bl_idname)
        row.menu("USERPREF_MT_interface_theme_presets", text="Theme",icon="TRIA_DOWN")
        
class BLCN_zh_CN_en_US(bpy.types.Operator):
    bl_idname = "blendercn.zh_cn_en_us"
    bl_label = "中/EN"
    bl_description = "切换blender界面语言"
    bl_options = {"REGISTER"}
    
    def execute(self, context):
        language=bpy.context.preferences.view.language
        zh_CN=["动画","合成","几何节点","布局","建模","渲染","脚本","雕刻","着色","纹理喷绘","UV编辑"]
        en_US=["Animation","Compositing","Geometry Nodes","Layout","Modeling","Rendering","Scripting","Sculpting","Shading","Texture Paint","UV Editing"]
        
        if language =='zh_CN':
            bpy.context.preferences.view.language = 'en_US'
            Allspace=bpy.data.workspaces
            for space in Allspace:
                for i in range(len(en_US)):
                    if zh_CN[i] in space.name:
                        name = str(space.name)
                        space.name = name.replace(zh_CN[i],en_US[i]);
        else:
            bpy.context.preferences.view.language = 'zh_CN'
            Allspace=bpy.data.workspaces
            for space in Allspace:
                for i in range(len(en_US)):
                    if en_US[i] in space.name:
                        name = str(space.name)
                        space.name = name.replace(en_US[i],zh_CN[i]);
        context.preferences.view.use_translate_new_dataname = False
        return {'FINISHED'}




def register():
    ...
    bpy.utils.register_class(BLCN_zh_CN_en_US)
    bpy.utils.register_class(BasicMenu)
    bpy.types.TOPBAR_MT_editor_menus.append(BasicMenu.draw)

def unregister():
    ...
    bpy.types.TOPBAR_MT_editor_menus.remove(BasicMenu.draw)
    
    bpy.utils.unregister_class(BLCN_zh_CN_en_US)
    bpy.utils.unregister_class(BasicMenu)
