bl_info = {
    "name": "资产按集合分类",
    "author": "BlenderCN极D创意",
    "version": (3, 6, 3),
    "blender": (3, 6, 0),
    "location": "View3D > N Panel > View",
    "description": "入口：在N面板视图中。一键将场景中可见的物体按照顶层父级的名称进行分类，之后可再大纲中选择所有的集合右键标记为资产。方便实用！",
    "category": "Object"
}

import bpy
import math
from mathutils import Vector
from bpy.types import Panel, Operator
import re
import unicodedata


def get_visible_objects_without_parent():
    # 获取当前场景中所有可见物体
    visible_objects = [obj for obj in bpy.context.scene.objects if obj.visible_get()]

    # 过滤出没有父级的物体
    objects_without_parent = [obj for obj in visible_objects if obj.parent is None]

    return objects_without_parent


def move_to_collection(obj, collection):
    # 将物体及其子集移动到集合中
    collection.objects.link(obj)
    for child in obj.children:
        move_to_collection(child, collection)


def move_visible_objects_to_collection():
    # 获取名为 "Collection" 的集合
    current_scene_name = bpy.context.scene.name
    collection = bpy.data.collections.get("Collection_" + current_scene_name)

    if collection is None:
        # 如果集合不存在，则创建一个新集合
        collection = bpy.data.collections.new("Collection_" + current_scene_name)
        bpy.context.scene.collection.children.link(collection)

    # 移动所有可见物体到集合中，并移除它们原有集合的关联
    for obj in bpy.context.selected_objects:
        original_collection = obj.users_collection[0]
        original_collection.objects.unlink(obj)
        collection.objects.link(obj)
    return collection





def delete_collection(collection):
    # 从场景的集合列表中移除集合
    bpy.context.scene.collection.children.unlink(collection)

    # 删除集合
    bpy.data.collections.remove(collection)


def clear_collection(collection):
    # 遍历集合中的物体
    for obj in collection.objects:
        # 从集合中移除物体
        collection.objects.unlink(obj)


def move_children_to_collection(obj, collection):
    for child in obj.children:
        if not child.hide_viewport:
            # 移动子集到集合中
            collection.objects.link(child)
            # 递归移动子集的子集
            move_children_to_collection(child, collection)

type_list=[]
def obj_to_list(self, context, type):
    if type in type_list:
        type_list.remove(type)
    else:
        type_list.append(type)


class Classify_realize_project(Operator):
    bl_idname = "classify.realize_project"
    bl_label = "Realize Project"

    func: bpy.props.StringProperty()

    def move_visible_light_to_collection(self, list):
        # 获取名为 "Light_Sence" 的集合
        list_name ="_".join(list)
        current_scene_name = bpy.context.scene.name
        collection = bpy.data.collections.get(list_name + "_" + current_scene_name)

        if collection is None:
            # 如果集合不存在，则创建一个新集合
            collection = bpy.data.collections.new(list_name + "_" + current_scene_name)
            bpy.context.scene.collection.children.link(collection)

        # 移动所有可见物体到集合中，并移除它们原有集合的关联
        for obj in bpy.context.visible_objects:
            if obj.type in list and obj.visible_get():
                original_collection = obj.users_collection[0]
                original_collection.objects.unlink(obj)
                collection.objects.link(obj)
        return collection

    def clear_custom_split_normals(self, obj):
        if obj.type == 'MESH':
            # 生成自定义拆边法向数据
            obj.data.create_normals_split()
            # 清除自定义拆边法向数据
            if obj.data.has_custom_normals:
                obj.data.use_auto_smooth = True
                bpy.context.view_layer.objects.active = obj
                bpy.ops.mesh.customdata_custom_splitnormals_clear()

    def delete_empty_collections(self):
        # 遍历场景中的所有集合
        for collection in bpy.context.scene.collection.children:
            # 检查集合是否没有物体
            if len(collection.objects) == 0:
                # 删除集合
                bpy.data.collections.remove(collection)

    def get_object_hierarchy_bbox(self, obj):
        # 获取物体的边界框
        bbox = [obj.matrix_world @ Vector(vertex) for vertex in obj.bound_box]
        if obj.children is None:
            return bbox
        # 遍历子集并更新边界框
        for child in obj.children:
            child_bbox = self.get_object_hierarchy_bbox(child)
            bbox.extend(child_bbox)

        return bbox

    def arrange_objects_with_equal_spacing(self):
        # 设置物体之间的间距
        spacing = 1.0
        set_row = 1

        objects = bpy.context.selected_objects
        if not objects:
            return
        raduis = 0
        set_num = math.ceil(len(objects) / set_row)
        # 计算每个物体的 x 位置
        for i, obj in enumerate(objects):

            # 计算整体边界框的范围
            min_x = min(self.get_object_hierarchy_bbox(obj), key=lambda v: v.x).x
            max_x = max(self.get_object_hierarchy_bbox(obj), key=lambda v: v.x).x
            # min_y = min(self.get_object_hierarchy_bbox(obj), key=lambda v: v.y).y
            # max_y = max(self.get_object_hierarchy_bbox(obj), key=lambda v: v.y).y
            # min_z = min(self.get_object_hierarchy_bbox(obj), key=lambda v: v.z).z
            # max_z = max(self.get_object_hierarchy_bbox(obj), key=lambda v: v.z).z
            total_width = max_x - min_x + spacing
            length_min_x = obj.location.x - min_x
            length_max_x = max_x - obj.location.x

            if i > 0:
                # 设置物体的位置
                obj.location.x = raduis + length_min_x + spacing
                obj.location.y = 0
                obj.location.z = 0
                raduis += total_width

            else:
                obj.location.x = 0
                obj.location.y = 0
                obj.location.z = 0
                raduis = length_max_x

    # 获取所有选择的物体的材质
    def get_selected_objects_materials(self):
        selected_objects = bpy.context.selected_objects
        materials = []

        for obj in selected_objects:
            for slot in obj.material_slots:
                if slot.material not in materials:
                    materials.append(slot.material)

        return materials
    # 移除孤立顶点
    def delete_isolated_vertices(self,obj):

        # 进入编辑面模式
        bpy.ops.object.mode_set(mode='EDIT')
        # 取消隐藏
        bpy.ops.mesh.reveal()
        bpy.ops.mesh.select_mode(type='FACE')
        bpy.ops.mesh.select_all(action='SELECT')

        # 隐藏所有面
        bpy.ops.mesh.hide(unselected=False)

        # 进入编辑边模式
        bpy.ops.mesh.select_mode(type='EDGE')
        bpy.ops.mesh.select_all(action='SELECT')

        # 删除所有的边
        bpy.ops.mesh.delete(type='EDGE')

        # 取消隐藏
        bpy.ops.mesh.reveal()

        # 进入编辑面模式
        bpy.ops.mesh.select_mode(type='FACE')
        bpy.ops.mesh.select_all(action='SELECT')

        # 隐藏所有面
        bpy.ops.mesh.hide(unselected=False)

        # 进入点模式
        bpy.ops.mesh.select_mode(type='VERT')
        bpy.ops.mesh.select_all(action='SELECT')

        # 删除所有点
        bpy.ops.mesh.delete(type='VERT')

        # 取消隐藏
        bpy.ops.mesh.reveal()

        # 退出编辑模式
        bpy.ops.object.mode_set(mode='OBJECT')
    def execute(self, context):
        selected_objects = bpy.context.selected_objects
        # 执行方法

        if self.func == "clear_normal":
            for obj in selected_objects:
                self.clear_custom_split_normals(obj)

        elif self.func == "clear_materials":
            for obj in bpy.context.selected_objects:
                bpy.context.view_layer.objects.active = obj
                bpy.ops.object.material_slot_remove_unused()

        elif self.func == "No_Alpha":
            mesh_objects = [obj for obj in selected_objects if obj.type == 'MESH']

            # 将材质设置为Opaque模式
            for obj in mesh_objects:
                for slot in obj.material_slots:
                    if slot.material:
                        slot.material.blend_method = 'OPAQUE'
                        slot.material.use_nodes = True
                        nodes = slot.material.node_tree.nodes
                        principled_bsdf = nodes.get("原理化BSDF")
                        if principled_bsdf:
                            principled_bsdf = nodes.get("Principled BSDF")
                        if principled_bsdf:
                            principled_bsdf.inputs["Alpha"].default_value = 1.0

        elif self.func == "set_OBJ_white":
            for obj in selected_objects:
                # 检查物体是否是网格类型，因为只有网格类型的物体才有材质
                if obj.type == 'MESH':
                    # 检查物体是否有材质
                    if obj.data.materials:
                        # 遍历物体的所有材质
                        for mat in obj.data.materials:
                            # 将材质的视图显示颜色设置为白色
                            mat.diffuse_color = (1, 1, 1, 1)

        elif self.func == "clear_byte_O_name":
            for obj in selected_objects:
                obj.name = re.sub(r'[^\x00-\x7F\u4E00-\u9FA5]', '', obj.name)
                try:
                    pass
                except:
                    obj.name = "untitle_obj"
        elif self.func == "clear_byte_M_name":

            # 获取所有材质
            materials=self.get_selected_objects_materials()
            # 删除所有材质名称中的特殊字符
            for material in materials:
                # 使用正则表达式匹配特殊字符并替换为空字符串
                try:
                    material.name =re.sub(r'[^\x00-\x7F\u4E00-\u9FA5]', '', obj.name)
                except:
                    material.name = "untitle_material"

        elif self.func == "setpos":
            self.arrange_objects_with_equal_spacing()

        elif self.func == "clear_collection":
            self.delete_empty_collections()

        elif self.func == "set_same_data_name":
            for obj in selected_objects:
                if obj.type != 'EMPTY':
                    obj.name = obj.data.name

        elif self.func == "set_same_obj_name":
            for obj in selected_objects:
                if obj.type != 'EMPTY':
                    obj.data.name = obj.name

        elif self.func == "delete_isolated_vertices":
            for obj in selected_objects:
                if obj.type == 'MESH':
                    self.delete_isolated_vertices(obj)

        elif self.func == "delete_None_obj":
            # 获取当前场景
            scene = context.scene

            # 遍历当前场景中的所有对象
            for obj in scene.objects:
                if obj.type == 'MESH':
                    # 获取物体的顶点数量
                    num_vertices = len(obj.data.vertices)

                    # 如果顶点数量为0，则选择并删除物体
                    if num_vertices == 0:
                        bpy.context.view_layer.objects.active = obj
                        bpy.ops.object.select_all(action='DESELECT')
                        obj.select_set(True)
                        bpy.ops.object.delete()

        elif self.func == "classify":
            if type_list:
                self.move_visible_light_to_collection(type_list)
            else:
                # 执行方法
                collection_obj = move_visible_objects_to_collection()

                # 遍历场景中的所有可见物体
                for obj in collection_obj.objects:
                    if obj.parent is None:

                        # 检查是否存在与物体名称相匹配的集合
                        collection_name = obj.name
                        collection = bpy.data.collections.get(collection_name)
                        if collection is None:
                            # 创建新集合并将物体及其子集移动到新集合中
                            collection = bpy.data.collections.new(collection_name)
                            bpy.context.scene.collection.children.link(collection)

                        collection.objects.link(obj)
                        move_children_to_collection(obj, collection)
                delete_collection(collection_obj)
        self.report({'INFO'}, '处理完成')
        return {'FINISHED'}



class ClassifyPanel(bpy.types.Panel):
    bl_idname = "OBJECT_PT_classify_tools"
    bl_label = "自动分类工具箱"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "Tool"

    def draw(self, context):
        layout = self.layout

        scene = context.scene

        # 创建一行布局
        row = layout.row(align=True)

        # 在第一列添加一个跨列的按钮，居中对齐
        col = row.column()
        col.scale_x = 2  # 跨两列的按钮
        col.operator("classify.realize_project", text="一键分类分类", icon="MODIFIER").func = "classify"

        # 第二行布局
        row = layout.row()
        col.label(text="单独提取：")
        # 第二行左侧列
        split = row.split()
        col = split.column()
        col.prop(context.scene, "checkbox_MESH", )
        col.prop(context.scene, "checkbox_LIGHT", )
        col.prop(context.scene, "checkbox_CURVE", )

        # 在第二列创建两列布局
        col = row.column()
        col.prop(context.scene, "checkbox_GPENCIL", )
        col.prop(context.scene, "checkbox_ARMATURE", )
        col.prop(context.scene, "checkbox_LATTICE", )

        col = row.column()
        col.prop(context.scene, "checkbox_EMPTY", )
        col.prop(context.scene, "checkbox_FONT")
        col.prop(context.scene, "checkbox_CAMERA", )

        col = row.column()
        col.prop(context.scene, "checkbox_SURFACE", )
        col.prop(context.scene, "checkbox_LIGHT_PROBE", )
        col.prop(context.scene, "checkbox_META", )

        # 创建一行布局
        row = layout.row(align=True)

        # 在第一列添加一个跨列的按钮，居中对齐
        split = row.split()
        col = split.column()
        col.operator("classify.realize_project", text="一字排列", icon="MODIFIER").func = "setpos"
        col = split.column()
        col.operator("classify.realize_project", text="清理空集合", icon="MODIFIER").func = "clear_collection"

        # 创建一行布局
        row = layout.row(align=True)

        # 在第一列添加一个跨列的按钮，居中对齐
        split = row.split()
        col = split.column()
        col.operator("classify.realize_project", text="物体名=数据名", icon="MODIFIER").func = "set_same_data_name"
        col = split.column()
        col.operator("classify.realize_project", text="数据名=物体名", icon="MODIFIER").func = "set_same_obj_name"

        # 创建一行布局
        row = layout.row(align=True)

        # 在第一列添加一个跨列的按钮，居中对齐
        split = row.split()
        col = split.column()
        col.operator("classify.realize_project", text="清空自定义拆边法向数据", icon="MODIFIER").func = "clear_normal"
        col = split.column()
        col.operator("classify.realize_project", text="清空物体中未使用的材质", icon="MODIFIER").func = "clear_materials"

        row = layout.row(align=True)
        split = row.split()
        col = split.column()
        col.operator("classify.realize_project", text="设置材质非透明", icon="MODIFIER").func = "No_Alpha"
        col = split.column()
        col.operator("classify.realize_project", text="物体显示为白色", icon="MODIFIER").func = "set_OBJ_white"
        # 创建一行布局
        row = layout.row(align=True)

        # 在第一列添加一个跨列的按钮，居中对齐
        split = row.split()
        col = split.column()
        col.operator("classify.realize_project", text="清除物体名称中的乱码",
                     icon="MODIFIER").func = "clear_byte_O_name"
        col = split.column()
        col.operator("classify.realize_project", text="清除材质名称中的乱码",
                     icon="MODIFIER").func = "clear_byte_M_name"
        # 创建一行布局
        row = layout.row(align=True)
        split = row.split()
        col = split.column()
        col.operator("classify.realize_project", text="移除孤立顶点", icon="MODIFIER").func = "delete_isolated_vertices"
        col = split.column()
        col.operator("classify.realize_project", text="删除空白网格", icon="MODIFIER").func = "delete_None_obj"




classes = (
    Classify_realize_project,
    ClassifyPanel,
)


def register():
    for cls in classes:
        bpy.utils.register_class(cls)
        bpy.types.Scene.checkbox_MESH = bpy.props.BoolProperty(name="网格",
                                                               update=lambda self, context: obj_to_list(self, context,
                                                                                                        "MESH"))
        bpy.types.Scene.checkbox_EMPTY = bpy.props.BoolProperty(name="空物体",
                                                                update=lambda self, context: obj_to_list(self, context,
                                                                                                         "EMPTY"))
        bpy.types.Scene.checkbox_CURVE = bpy.props.BoolProperty(name="曲线",
                                                                update=lambda self, context: obj_to_list(self, context,
                                                                                                         "CURVE"))
        bpy.types.Scene.checkbox_SURFACE = bpy.props.BoolProperty(name="曲面",
                                                                  update=lambda self, context: obj_to_list(self,
                                                                                                           context,
                                                                                                           "SURFACE"))
        bpy.types.Scene.checkbox_LATTICE = bpy.props.BoolProperty(name="晶格",
                                                                  update=lambda self, context: obj_to_list(self,
                                                                                                           context,
                                                                                                           "LATTICE"))
        bpy.types.Scene.checkbox_GPENCIL = bpy.props.BoolProperty(name="蜡笔",
                                                                  update=lambda self, context: obj_to_list(self,
                                                                                                           context,
                                                                                                           "GPENCIL"))
        bpy.types.Scene.checkbox_ARMATURE = bpy.props.BoolProperty(name="骨骼",
                                                                   update=lambda self, context: obj_to_list(self,
                                                                                                            context,
                                                                                                            "ARMATURE"))
        bpy.types.Scene.checkbox_FONT = bpy.props.BoolProperty(name="字体",
                                                               update=lambda self, context: obj_to_list(self, context,
                                                                                                        "FONT"))
        bpy.types.Scene.checkbox_LIGHT_PROBE = bpy.props.BoolProperty(name="光照探头",
                                                                      update=lambda self, context: obj_to_list(self,
                                                                                                               context,
                                                                                                               "LIGHT_PROBE"))
        bpy.types.Scene.checkbox_CAMERA = bpy.props.BoolProperty(name="相机",
                                                                 update=lambda self, context: obj_to_list(self, context,
                                                                                                          "CAMERA"))
        bpy.types.Scene.checkbox_META = bpy.props.BoolProperty(name="融球",
                                                               update=lambda self, context: obj_to_list(self, context,
                                                                                                        "META"))
        bpy.types.Scene.checkbox_LIGHT = bpy.props.BoolProperty(name="灯光",
                                                                update=lambda self, context: obj_to_list(self, context,
                                                                                                         "LIGHT"))


def unregister():
    for cls in classes:
        bpy.utils.unregister_class(cls)
        # 删除属性之前检查属性是否存在
        if hasattr(bpy.types.Scene, 'checkbox_MESH'):
            del bpy.types.Scene.checkbox_MESH
        if hasattr(bpy.types.Scene, 'checkbox_EMPTY'):
            del bpy.types.Scene.checkbox_EMPTY
        if hasattr(bpy.types.Scene, 'checkbox_CURVE'):
            del bpy.types.Scene.checkbox_CURVE
        if hasattr(bpy.types.Scene, 'checkbox_SURFACE'):
            del bpy.types.Scene.checkbox_SURFACE
        if hasattr(bpy.types.Scene, 'checkbox_LATTICE'):
            del bpy.types.Scene.checkbox_LATTICE
        if hasattr(bpy.types.Scene, 'checkbox_GPENCIL'):
            del bpy.types.Scene.checkbox_GPENCIL
        if hasattr(bpy.types.Scene, 'checkbox_ARMATURE'):
            del bpy.types.Scene.checkbox_ARMATURE
        if hasattr(bpy.types.Scene, 'checkbox_FONT'):
            del bpy.types.Scene.checkbox_FONT
        if hasattr(bpy.types.Scene, 'checkbox_LIGHT_PROBE'):
            del bpy.types.Scene.checkbox_LIGHT_PROBE
        if hasattr(bpy.types.Scene, 'checkbox_CAMERA'):
            del bpy.types.Scene.checkbox_CAMERA
        if hasattr(bpy.types.Scene, 'checkbox_META'):
            del bpy.types.Scene.checkbox_META
        if hasattr(bpy.types.Scene, 'checkbox_LIGHT'):
            del bpy.types.Scene.checkbox_LIGHT


if __name__ == "__main__":
    register()
