thisScriptPath = getThisScriptFilename()
thisScriptFilePath = getFilenamePath thisScriptPath
iniFile = thisScriptFilePath + "RH_M2B.ini"

filein (thisScriptFilePath + "core.mse")

main_ver = (getINISetting iniFile "RH_M2B" "main") as integer
branch_ver = (getINISetting iniFile "RH_M2B" "branch") as integer

export_format = getINISetting iniFile "RH_M2B" "format"
isUnsupportedUSD = USDExporter == undefined or export_format != "USD"
isUnsupportedVersion = main_ver < 3 or (main_ver == 3 and branch_ver < 5)

if (isUnsupportedUSD or isUnsupportedVersion) then (
    export_format = "FBX"
)else(
    export_format = "USD"
)

explode_group = getINISetting iniFile "RH_M2B" "ungroup"
if explode_group == "True" then (
    explode_group = true
) else (
    explode_group = false
)

keep_ngon = getINISetting iniFile "RH_M2B" "ngon"
if keep_ngon == "True" then (
    keep_ngon = true
) else (
    keep_ngon = false
)

clearListener()
print export_format
-- 1.FBX或USD格式导出 
-- 2.是否解组
-- 3.是否转Polygon（保持NGon结构）
Export export_format explode_group keep_ngon

-- 1. 字符串"FBX"或"USD",导出FBX或USD格式
-- 2. 0或1, 0表示全部物体， 1表示只导出选择的物体
ExportMesh export_format 0

---- Force stop this process and abort render
proc = dotNetObject "System.Diagnostics.Process"
info = proc.GetCurrentProcess()
pid = info.Id
DOSCommand ("taskkill /pid " + pid as string + " -t -f")
---- END