bl_info = {
    "name": "SelectAnimationSlotObject",
    "description": "获取动画插槽中的物体",
    "author": "zhaoguopei",
    "version": (1, 0),
    "blender": (4, 4, 0),  # 仅支持Blender 4.4及以上版本
    "location": "DopeSheet > N面板 > 选择",
    "warning": "",  # 用于显示警告信息
    "doc_url": "",  # 文档链接
    "category": "动画",
}

import bpy

# 自定义操作：获取活动物体
def get_animation_object_operator(self, context):
    selected_objects = bpy.context.selected_objects
    for obj in selected_objects:
        print("Selected Object:", obj.name)
    for obj in selected_objects:
        if obj.animation_data:
            print(f"Object '{obj.name}' has animation data.")
            if obj.animation_data.action:
                print(f"  Action: {obj.animation_data.action.name}")
                action=obj.animation_data.action
                for i in action.slots:
                    print(i.name_display)
                    if i.name_display in bpy.data.objects:
                        obj = bpy.data.objects[i.name_display]
                        obj.select_set(True)  # 选择物体
                        bpy.context.view_layer.objects.active = obj  # 设置为活动物体
                    else:
                        print(f"物体 '{obj_name}' 不存在")
            if obj.animation_data.nla_tracks:
                for track in obj.animation_data.nla_tracks:
                    print(f"  NLA Track: {track.name}")
                    for strip in track.strips:
                        print(f"    Strip: {strip.name}, Action: {strip.action.name}")
                        action=strip.action
                        for i in action.slots:
                            print(i.name_display)
                            if i.name_display in bpy.data.objects:
                                obj = bpy.data.objects[i.name_display]
                                obj.select_set(True)  # 选择物体
                                bpy.context.view_layer.objects.active = obj  # 设置为活动物体
        else:
            print(f"Object '{obj.name}' has no animation data.")


# 自定义面板类
class DOPESHEET_PT_CustomPanel(bpy.types.Panel):
    bl_label = "获取对象"  # 面板标题
    bl_space_type = 'DOPESHEET_EDITOR'  # 面板显示在动画摄影表中
    bl_region_type = 'UI'  # 面板显示在N面板中
    bl_category = "选择"  # 面板所属的侧边栏分类

    def draw(self, context):
        layout = self.layout
        # 添加一个按钮，点击后执行 get_active_object_operator
        layout.operator("wm.get_active_object", text="获取对象")

# 自定义操作类
class WM_OT_GetActiveObject(bpy.types.Operator):
    bl_idname = "wm.get_active_object"  # 操作ID
    bl_label = "获取对象"  # 操作名称
    bl_description = "获取当前活动物体"  # 操作描述

    def execute(self, context):
        get_animation_object_operator(self, context)
        return {'FINISHED'}

# 注册类和取消注册函数
def register():
    bpy.utils.register_class(DOPESHEET_PT_CustomPanel)
    bpy.utils.register_class(WM_OT_GetActiveObject)

def unregister():
    bpy.utils.unregister_class(DOPESHEET_PT_CustomPanel)
    bpy.utils.unregister_class(WM_OT_GetActiveObject)

if __name__ == "__main__":
    register()