bl_info = {
    "name": "RenderSwitch",
    "author": "Deathblood",
    "version": (1, 0),
    "blender": (4, 2, 0),
    "location": "大纲视图 > 头部",
    "description": "管理隐藏和显示物体的渲染可见性",
}

import bpy

class OBJECT_OT_hide_render_for_hidden_objects(bpy.types.Operator):
  
    bl_idname = "object.hide_render_for_hidden_objects"
    bl_label = "管理隐藏和显示物体的渲染可见性"
    bl_options = {'REGISTER', 'UNDO'}  
    bl_description = "视图隐藏→渲染隐藏 | 视图显示→渲染显示"
    
    def execute(self, context):
        obj_count = 0
        for obj in bpy.context.scene.objects:
            if obj.hide_get():               
                if not obj.hide_render: 
                    obj.hide_render = True
                    obj_count += 1
            else: 
                if obj.hide_render:  
                    obj.hide_render = False
                    obj_count += 1

        self.report({'INFO'}, f"已为 {obj_count} 个物体处理可渲染性！")
        return {'FINISHED'}

def draw_outliner_header_button(self, context):
    layout = self.layout
    row = layout.row()
    row.alignment = 'LEFT'  
    row.operator(OBJECT_OT_hide_render_for_hidden_objects.bl_idname, text="渲切",icon='RESTRICT_RENDER_OFF')
   
def register():
    bpy.utils.register_class(OBJECT_OT_hide_render_for_hidden_objects)
    bpy.types.OUTLINER_HT_header.append(draw_outliner_header_button)

def unregister():
    bpy.types.OUTLINER_HT_header.remove(draw_outliner_header_button)
    bpy.utils.unregister_class(OBJECT_OT_hide_render_for_hidden_objects)
    

if __name__ == "__main__":
    register()